import re
from enum import Enum

class SceneType(Enum):
    EMPTY = 'Empty Comp Starter'
    APPEND_SCENE = 'Append Scene'
    LINK_SCENE = 'Link Scene'

    @staticmethod
    def get_type(scene_type_str):
        for scene_type in SceneType:
            if scene_type.value == scene_type_str:
                return scene_type
        return SceneType.APPEND_SCENE  # return default if no matching member is found


class RunScope(Enum):
    TAKE = "Take"
    DAY = "Day"
    PROJECT = "Project"
    SAME_USDZ = "Same USDZ"

    @staticmethod
    def get_type(run_scope_str):
        for run_scope in RunScope:
            if run_scope.value == run_scope_str:
                return run_scope
        return RunScope.TAKE # return default if no matching member is found




class ImportArguments:
        def __init__(self):
            self.sceneblendpath = ""
            self.depthperson = False
            self.cameraname = "camera"
            self.exportbase = None
            self.scenetype = SceneType.EMPTY
            self.runtype = RunScope.TAKE
            self.composite = False

        @classmethod
        def parseuuid(self,str):
            """
            Find first uuid match in a string
            """
            # Older full uuid version
            uuid_extract_pattern = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-5][0-9a-fA-F]{3}-[089abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}"
            m = re.findall(uuid_extract_pattern, str) # returns ['123e4567-e89b-12d3-a456-426614174000']
            if len(m) > 0:
                return m[0]

            # Look for short version
            #uuid_extract_pattern = "[0-9a-fA-F]{10}"
            uuid_extract_pattern = r"_(?P<uuid>[0-9a-fA-F]{10})"

            m = re.findall(uuid_extract_pattern, str) # returns ['6614174000']
            if len(m) > 0:
                return m[0]

            return ""

        # seed camera name
        def pulluuid(self):
            #print(f"self.trackingpath {self.trackingpath}")
            #self.uuid = ImportArguments.parseuuid(self.trackingpath)
            self.cameraname = self.exportbase.shortname + self.exportbase.namesuffix

        def cameraname(self):
            return self.cameraname


if __name__ == "__main__":
    print("run test here")
    ia = ImportArguments()
    ia.trackingpath = "/tmp/SC121a_TK002_001_45477BA0-1299-43E6-8F2B-FC9735BDD16F_zipline_tracking.json"

    ia.pulluuid()
    print(f"uuid {ia.uuid}")

    ia.trackingpath = "/tmp/greg1_SC101_TK019_A001_1080P-709__318751E479_zl_tracking.json"

    ia.pulluuid()
    print(f"uuid {ia.uuid}")

