# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

Autoshot is a Blender addon for VFX compositing and camera tracking workflows, developed by Lightcraft Technology. It supports Blender 4.2.1+ and includes Blender 5.0 compatibility.

## Development Environment

- Testing is done in parallel with PyCharm running under Windows in the same folder
- Never git commit unless explicitly instructed
- The addon is installed in Blender via Edit > Preferences > Add-ons > Install from Disk
- To test changes, reload the addon in Blender or restart Blender

## Architecture

### Entry Point & Registration
- `__init__.py`: Standard Blender addon structure with `bl_info`, registers all classes (panels, operators, properties)
- `MyProperties`: Scene-level property group storing all configuration (paths, flags, render settings)
- `MyAddonPreferences`: Addon preferences panel
- Hot-reload pattern implemented via `importlib.reload` for development

### Core Modules

| Module | Purpose |
|--------|---------|
| `Autoimport.py` | Main import workflow, tracking JSON parsing, FrameIntermediate data structures, primary UI panel |
| `utiloperators.py` | Secondary UI panels (LONET, UNREAL, SPLATUTIL, DEV_TESTING), utility operators |
| `exportsplattrain.py` | Camera path generation, splat training workflows, Reality Capture export |
| `Composite.py` | Compositing node setup, colorspace management, template handling |
| `make_scene.py` | USD asset import, scene hierarchy building, rescaling |
| `make_assets.py` | Material deduplication, asset instancing, mesh linking |
| `daily.py` | Render setup and timeline management |
| `CameraPlane.py` | Image plane creation for cameras, texture application |
| `imageloading.py` | Image sequence detection and frame mapping |
| `lonet.py` | Live tracking via UDP socket (Lonet2 integration on port 40000) |
| `exportbase.py` | Data serialization/deserialization classes (ExportBase, ExportCamera, CameraFrame, SceneLoc, MediaEntry, Keyer) |
| `argutil.py` | Enum definitions (SceneType, RunScope) and ImportArguments class |
| `utilfunctions.py` | USD utilities, mesh linking, hierarchy traversal |

### Vendor Code
- `vendor/t3dn_bip/`: Third-party image preview collection system for icons

### Version Management
- `version.py`: Contains `versiontuple` - must be kept in sync with `bl_info["version"]` in `__init__.py`

## Data Flow

1. JSON tracking data → `Autoimport.py`
2. `ImportArguments` configuration → Scene setup
3. `ExportBase` classes → Serialized export parameters
4. Camera/image processing → `CameraPlane.py`, `imageloading.py`
5. USD scene import → `make_scene.py` + `make_assets.py`
6. Composite setup → `Composite.py`
7. Rendering → `daily.py`

## Key External Dependencies

- **PIX USD Library**: Used in `make_scene.py` and `utilfunctions.py` for USD file parsing (`Usd.Stage`, `UsdGeom.Mesh`, `UsdGeom.Scope`)
- Standard Blender API (bpy)

## UI Panels

Located in View3D sidebar under "Autoshot":
- **AFTERBURNER_PT_Panel**: Main panel with render and import operators
- **LONET_PT_Panel**: Live tracking controls
- **UNREAL_PT_Panel**: Unreal Engine workflows
- **SPLATUTIL_PT_Panel**: Splat training utilities
- **ZIPUTIIL_PT_Panel**: Dev testing (collapsed by default)

## Key Files for Common Tasks

- **Adding new operators**: Register in `__init__.py`, implement in appropriate module
- **Modifying import workflow**: `Autoimport.py`
- **Changing export formats**: `exportbase.py`, `exportsplattrain.py`
- **USD pipeline changes**: `make_scene.py`, `make_assets.py`, `utilfunctions.py`
- **Compositing changes**: `Composite.py`
- **Live tracking**: `lonet.py`
