# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# Import version first to be available for bl_info
from . import version


# ----------------------------------------------
# Import modules
# ----------------------------------------------
if "bpy" in locals():
    from importlib import reload
    reload(version)
    reload(Autoimport)
    reload(utiloperators)
    reload(Composite)
    reload(imageloading)
    reload(icons)
    reload(make_assets)
    reload(make_scene)
    reload(utilfunctions)
    reload(lonet)
    reload(exportsplattrain)
else:
    from . import Autoimport
    from . import utiloperators
    from . import Composite
    from . import imageloading
    from . import icons
    from . import make_assets
    from . import make_scene
    from . import utilfunctions
    from . import lonet
    from . import exportsplattrain

import bpy
import os
from bpy.props import StringProperty, PointerProperty, BoolProperty
from bpy.types import PropertyGroup
from bpy.app.handlers import persistent


bl_info = {
 "name": "Lightcraft Technology Autoshot",
 "description": "Addon for importing tracking files and compositing",
 "author": "Lightcraft Technology",
 "blender": (4, 2, 1),
 "version":  (1, 0, 136),
 "support": "COMMUNITY",
 "category": "Sequencer",
 "location": "View3D > Toolshelf > Autoshot",
}


class MyAddonPreferences(bpy.types.AddonPreferences):
    bl_idname = __name__
    version = bl_info["version"]
    
    # Define your properties here
    my_property: bpy.props.StringProperty(name="Unused Property", default="Default Value")
    
    def draw(self, context):
        layout = self.layout
        layout.label(text="Placeholder in the preferences panel.")
        layout.prop(self, "my_property")


class MyProperties(PropertyGroup):
    filename_ext = ".json"

    blendfilepath: StringProperty(
        default="",
        options={'HIDDEN'},
        maxlen=1024,  
        subtype='DIR_PATH')

    exportfilepath: StringProperty(
        default="",
        options={'HIDDEN'},
        maxlen=1024,  
        subtype='DIR_PATH')

    sceneblendpath: StringProperty(
        default="",
        options={'HIDDEN'},
        maxlen=1024,  
        subtype='DIR_PATH')

    fastdebug_boolean: BoolProperty(
        name='faster testing',
        description='PNG overwrite for faster testing',
        default=False,
    )   


    renderdir : StringProperty(name="renderdir",options={'HIDDEN'},maxlen=1024, subtype='FILE_PATH')
    superpath : StringProperty(name="superpath",options={'HIDDEN'},maxlen=1024, subtype='FILE_PATH')
    livekey: BoolProperty(name='faster testing', description='True for livekey render pass', default=True)   

    utilpath : StringProperty(name="utilpath",default="D:/tmp",options={'HIDDEN'},maxlen=1024, subtype='FILE_PATH')
    assetusdpath : StringProperty(name="assetusdpath",default="*.usd",options={'HIDDEN'},maxlen=1024, subtype='FILE_PATH')
    assetblendpath : StringProperty(name="assetblendpath",default="*.blend",options={'HIDDEN'},maxlen=1024, subtype='FILE_PATH')
    command : StringProperty(name="command",default="",options={'HIDDEN'},maxlen=64)
    jsoncommand : StringProperty(name="jsoncommand",options={'HIDDEN'},maxlen=2048)
    scenetype : StringProperty(name="scenetype",default="",options={'HIDDEN'},maxlen=32)
    runtype : StringProperty(name="runtype",default="",options={'HIDDEN'},maxlen=32)
    cameraname : StringProperty(name="cameraname",default="",options={'HIDDEN'},maxlen=64)
    animationsync: BoolProperty(name='Animation Synchronization', description='Sync animation time with lonet2 anim timing', default=False)   
    quickrender_boolean: BoolProperty(
        name='Quick Render After Import',
        description='Automatically start a fast viewport render after import completes',
        default=False,
    )


classes = (
    Autoimport.AFTERBURNER_PT_Panel,
    utiloperators.LONET_PT_Panel,
    utiloperators.UNREAL_PT_Panel,
    utiloperators.SPLATUTIL_PT_Panel,
    utiloperators.ZIPUTIIL_PT_Panel,
    Autoimport.DailyOperator,
    Autoimport.ViewportRenderOperator,
    Autoimport.StandardRenderOperator,
    Autoimport.ImportOperator,
    Autoimport.OpenUrlOperator,
    utiloperators.MakeAssetsOperator,
    utiloperators.MakeSceneOperator,
    utiloperators.TestOperator,
    exportsplattrain.GenerateCameraPathOperator,
    exportsplattrain.ExportCameraPosesToXMP,
    exportsplattrain.ExportCameraPosesToColmap,
    exportsplattrain.RunRealityCapture,
    exportsplattrain.GenerateCameraPatternMeshOperator, 
    exportsplattrain.GenerateIcoSphereOperator, 
    exportsplattrain.AnimateCameraAlongFaceNormalsOperator,
    utiloperators.UtilOperator,
    MyAddonPreferences,
)

modules = (
    icons,
)

# ------------------------------------------------------------------------
#    Scene Properties
# ------------------------------------------------------------------------


def register():
    from bpy.utils import register_class

    register_class(MyProperties)

    bpy.types.Scene.AFTERBURNER = PointerProperty(type=MyProperties)

    #print("bpy.types.Scene.AFTERBURNER is at start ",bpy.types.Scene.AFTERBURNER)
    cwd = os.getcwd()
    print(f"Current working directory: {cwd}")
    #print(f"Tracking.__file__: {Tracking.__file__}")

    for cls in classes:
        register_class(cls)

    for module in modules:
        module.register()

    lonet.register()

def unregister():
    from bpy.utils import unregister_class

    for module in reversed(modules):
        module.unregister()

    for cls in reversed(classes):
        unregister_class(cls)


    del bpy.types.Scene.AFTERBURNER  
    unregister_class(MyProperties)

    lonet.unregister()


if __name__ == "__main__":
    register()
