from pathlib import Path

from ..vendor.t3dn_bip import previews

previews.settings.WARNINGS = False

folder = Path(__file__).parent
collection: previews.ImagePreviewCollection = None


def get(name: str) -> int:
    path = str(folder.joinpath(name).with_suffix('.bip'))
    return collection.load_safe(path, path, 'IMAGE').icon_id


def register():
    global collection
    collection = previews.new(max_size=(32, 32), lazy_load=False)


def unregister():
    previews.remove(collection)
