@echo off
set "RealityCaptureExe="

for %%P in ("C:\Program Files\Capturing Reality\RealityCapture\RealityCapture.exe" "D:\Program Files\Capturing Reality\RealityCapture\RealityCapture.exe") do (
    if exist "%%~P" (
        set "RealityCaptureExe=%%~P"
        goto :FoundRCExe
    )
)

:FoundRCExe
if not defined RealityCaptureExe (
    echo RealityCapture.exe not found in predefined paths.
    echo Please enter the full path to RealityCapture.exe:
    set /p RealityCaptureExe=
    if not exist "%RealityCaptureExe%" (
        echo The specified file does not exist.
        pause
        exit /b 1
    )
)


:: Variable storing path to images for creating model (current directory)
set "Images=%CD%"

:: Set a new name for the calculated model
set "ModelName=SplatModel"

:: Define Metadata folder
set "Metadata=%RootFolder%Metadata"

:: Variable storing the path of the parameters file
set "ExportRegParams=%CD%\ExportRegParams.xml"

:: Create ExportRegParams.xml with the new content
> "%ExportRegParams%" (
    echo ^<Configuration id="{2D5793BC-A65D-4318-A1B9-A05044608385}"^>
    echo   ^<entry key="calexTrans" value="1"/^>
    echo   ^<entry key="calexHasDisabled" value="0x0"/^>
    echo   ^<entry key="MvsExportScaleZ" value="1.0"/^>
    echo   ^<entry key="MvsExportIsGeoreferenced" value="0x1"/^>
    echo   ^<entry key="MvsExportIsModelCoordinates" value="0"/^>
    echo   ^<entry key="MvsExportScaleY" value="1.0"/^>
    echo   ^<entry key="MvsExportScaleX" value="1.0"/^>
    echo   ^<entry key="MvsExportRotationY" value="0.0"/^>
    echo   ^<entry key="MvsExportcoordinatesystemtype" value="0"/^>
    echo   ^<entry key="MvsExportNormalFlipZ" value="false"/^>
    echo   ^<entry key="MvsExportRotationX" value="0.0"/^>
    echo   ^<entry key="hasCalexFilePath" value="1"/^>
    echo   ^<entry key="MvsExportNormalFlipY" value="false"/^>
    echo   ^<entry key="MvsExportNormalSpace" value="Mikktspace"/^>
    echo   ^<entry key="calexHasUndistort" value="-1"/^>
    echo   ^<entry key="MvsExportNormalFlipX" value="false"/^>
    echo   ^<entry key="MvsExportRotationZ" value="0.0"/^>
    echo   ^<entry key="calexFileFormat" value="Internal/External camera parameters"/^>
    echo   ^<entry key="MvsExportMoveZ" value="0.0"/^>
    echo   ^<entry key="calexFileFormatId" value="{0CA18733-1EBC-4254-9974-17197EB409BD}"/^>
    echo   ^<entry key="hasCalexFileName" value="1"/^>
    echo   ^<entry key="calexHasImageExport" value="-1"/^>
    echo   ^<entry key="MvsExportMoveX" value="0.0"/^>
    echo   ^<entry key="MvsExportNormalRange" value="ZeroToOne"/^>
    echo   ^<entry key="MvsExportMoveY" value="0.0"/^>
    echo ^</Configuration^>
)

set "ExportSparsePointCloudParams=%CD%\ExportSparsePointCloudParams.xml"

> "%ExportSparsePointCloudParams%" (
    echo ^<Configuration id="{2D5793BC-A65D-4318-A1B9-A05044608385}"^>
    echo   ^<entry key="calexTrans" value="1"/^>
    echo   ^<entry key="bAscii" value="false"/^>
    echo   ^<entry key="calexHasDisabled" value="0x0"/^>
    echo   ^<entry key="bVertexColor" value="true"/^>
    echo   ^<entry key="MvsExportScaleZ" value="1.0"/^>
    echo   ^<entry key="MvsExportIsGeoreferenced" value="0x1"/^>
    echo   ^<entry key="MvsExportIsModelCoordinates" value="0"/^>
    echo   ^<entry key="MvsExportScaleY" value="1.0"/^>
    echo   ^<entry key="MvsExportScaleX" value="1.0"/^>
    echo   ^<entry key="MvsExportRotationY" value="0.0"/^>
    echo   ^<entry key="MvsExportcoordinatesystemtype" value="0"/^>
    echo   ^<entry key="MvsExportNormalFlipZ" value="false"/^>
    echo   ^<entry key="MvsExportRotationX" value="0.0"/^>
    echo   ^<entry key="hasCalexFilePath" value="1"/^>
    echo   ^<entry key="MvsExportNormalFlipY" value="false"/^>
    echo   ^<entry key="MvsExportNormalSpace" value="Mikktspace"/^>
    echo   ^<entry key="calexHasUndistort" value="-1"/^>
    echo   ^<entry key="MvsExportNormalFlipX" value="false"/^>
    echo   ^<entry key="MvsExportRotationZ" value="0.0"/^>
    echo   ^<entry key="calexFileFormat" value="Sparse point cloud as Polygon File Format (*.ply)"/^>
    echo   ^<entry key="MvsExportMoveZ" value="0.0"/^>
    echo   ^<entry key="calexFileFormatId" value="{B63136B7-2E64-4D08-B5B1-A945F1AED679}"/^>
    echo   ^<entry key="hasCalexFileName" value="1"/^>
    echo   ^<entry key="calexHasImageExport" value="-1"/^>
    echo   ^<entry key="MvsExportMoveX" value="0.0"/^>
    echo   ^<entry key="MvsExportNormalRange" value="ZeroToOne"/^>
    echo   ^<entry key="MvsExportMoveY" value="0.0"/^>
    echo ^</Configuration^>
)

:: Set export camera parameters file
set "ExportReg=%CD%\%ModelName%_cameras.csv"

:: Set the path where the sparse point cloud will be saved
set "SparsePointCloud=%CD%\%ModelName%_sparse.ply"

:: Variable storing path to project
set "Project=%CD%\%ModelName%.rcproj"

:: Delete the existing .csv file if it exists
if exist "%ExportReg%" del "%ExportReg%"

:: Delete the existing sparse point cloud file if it exists
if exist "%SparsePointCloud%" del "%SparsePointCloud%"

:: Run RealityCapture
"%RealityCaptureExe%" -addFolder "%Images%" ^
-set "sfmImagesOverlap=Low" ^
-set "sfmCameraPriorWeight=1000.0" ^
-set "sfmCameraPriorWeightOrientation=1000.0" ^
-set "sfmCameraPriorAccuracyX=0.0" ^
-set "sfmCameraPriorAccuracyY=0.0" ^
-set "sfmCameraPriorAccuracyZ=0.0" ^
-align ^
-setReconstructionRegionAuto ^
-save "%Project%" ^
-exportRegistration "%ExportReg%" "%ExportRegParams%" ^
-exportSparsePointCloud "%SparsePointCloud%" "%ExportSparsePointCloudParams%" ^
-quit

