import re
import bpy
import os
import time
from .make_scene import make_scene
from .make_assets import make_assets
from bpy_extras.io_utils import ImportHelper,ExportHelper
import os.path
from bpy.props import StringProperty
from pathlib import Path,PurePath
from .Composite import CompositeKey
from .daily import setup_render_path 
from bpy.types import bpy_prop_collection
from bpy_extras.image_utils import load_image
from .lonet import StartLonet2Operator
from .exportsplattrain import GenerateCameraPathOperator,ExportCameraPosesOperator,ExportCameraPosesToColmap, ExportCameraPosesToXMP, RunRealityCapture, GenerateCameraPatternMeshOperator, AnimateCameraAlongFaceNormalsOperator, GenerateIcoSphereOperator

# Find all references to an ID    
def search(ID):
    def users(col):
        ret =  tuple(repr(o) for o in col if o.user_of_id(ID))
        return ret if ret else None
    return filter(None, (
        users(getattr(bpy.data, p)) 
        for p in  dir(bpy.data) 
        if isinstance(
                getattr(bpy.data, p, None), 
                bpy_prop_collection
                )                
        )
        )

class LONET_PT_Panel(bpy.types.Panel):
    bl_idname = "LONET_PT_Panel"
    bl_label = "Live Tracking"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "Autoshot"
    bl_context = "objectmode"    

    button_text = "Start Lonet2"

    def draw(self, context):
        layout = self.layout

        row = layout.row()                
        row.operator(StartLonet2Operator.bl_idname, text=self.button_text)

        # Add checkbox for the BoolProperty
        layout.prop(bpy.context.scene.AFTERBURNER, "animationsync")

class ZIPUTIIL_PT_Panel(bpy.types.Panel):
    bl_idname = "ZIPUTIIL_PT_Panel"
    bl_label = "Dev Testing Area"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "Autoshot"
    bl_context = "objectmode"    
    bl_options = {'DEFAULT_CLOSED'}

    usdpath: StringProperty(
        default="",
        #options={'HIDDEN'},
        maxlen=1024,  
        subtype='DIR_PATH')

    def draw(self, context):
        layout = self.layout
        row = layout.row()                
        row.prop(bpy.context.scene.AFTERBURNER,"utilpath", text="For util operators")

        row = layout.row()                
        row.operator(TestOperator.bl_idname, text="test", icon="IMPORT")
        row = layout.row()                

        #row = layout.row()                
        #row.operator(ExportCameraPosesOperator.bl_idname, text="Export Camera Pose csv in RealityCapture format")


class SPLATUTIL_PT_Panel(bpy.types.Panel):
    bl_idname = "SPLATUTIL_PT_Panel"
    bl_label = "Splat Training"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "Autoshot"
    bl_context = "objectmode"    
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        layout = self.layout

        row = layout.row()                
        row.operator(GenerateCameraPatternMeshOperator.bl_idname, text="Room Rings Pattern Mesh")
        row = layout.row()                
        row.operator(GenerateIcoSphereOperator.bl_idname, text="ICO Sphere Pattern Mesh")
        row = layout.row()                
        row.operator(AnimateCameraAlongFaceNormalsOperator.bl_idname, text="Camera Track Face Normals")

        # Add a separator to visually separate groups
        layout.separator()

        row = layout.row()                
        row.operator(ExportCameraPosesToColmap.bl_idname, text="Export cameras.txt and images.txt for COLMAP")

        # Add a separator to visually separate groups
        #layout.separator()

        #row = layout.row()                
        #row.operator(ExportCameraPosesToXMP.bl_idname, text="Export RealityCapture xmp")

        #row = layout.row()                
        #row.operator(RunRealityCapture.bl_idname, text="Run RealityCapture")




class UNREAL_PT_Panel(bpy.types.Panel):
    bl_idname = "UNREAL_PT_Panel"
    bl_label = "Unreal to Blender"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "Autoshot"
    bl_context = "objectmode"    
    bl_options = {'DEFAULT_CLOSED'}

    usdpath: StringProperty(
        default="",
        #options={'HIDDEN'},
        maxlen=1024,  
        subtype='DIR_PATH')

    def draw(self, context):
        layout = self.layout
        row = layout.row()                
        row.prop(bpy.context.scene.AFTERBURNER,"assetusdpath", text="Top level usd file")

        row = layout.row()                
        row.operator(MakeAssetsOperator.bl_idname, text="Make Assets", icon="IMPORT")

        row = layout.row()                
        row.prop(bpy.context.scene.AFTERBURNER,"assetblendpath", text="Asset blend saved after above")

        row = layout.row()                
        row.operator(MakeSceneOperator.bl_idname, text="Make Scene", icon="IMPORT")


class MakeSceneOperator(bpy.types.Operator):
    """Make a scene from assets"""
    bl_idname = "afterburner.make_scene"
    bl_label = "Make Scene from blend"

    filename_ext = ".blend"
    filter_glob: bpy.props.StringProperty(default='*.blend', subtype='FILE_PATH', options={'HIDDEN'})

    def execute(self, context):
        userpath = bpy.context.scene.AFTERBURNER.assetblendpath
        if os.path.splitext(userpath)[1].lower() != ".blend":
            self.report({'WARNING'}, "Pick the asset *.blend created above.")
            return {'FINISHED'}

        usedir = os.path.dirname(userpath)
        if not os.path.isdir(os.path.join(usedir, "Assets")):
            self.report({'WARNING'},
                        "Assets folder not found next to the blend file.")
            return {'FINISHED'}

        make_scene(userpath)         # ← nothing else needs changing
        return {'FINISHED'}

class MakeAssetsOperator(bpy.types.Operator):
    """Make assets from Unreal export"""
    bl_idname = "afterburner.make_assets"
    bl_label = "Make Assets From usd"

    filename_ext = ".usd"
    filter_glob: bpy.props.StringProperty(default='*.usd', subtype='FILE_PATH', options={'HIDDEN'})

    #def invoke(self, context, event):
    #    wm = context.window_manager
    #    return wm.invoke_props_dialog(self)

    def execute(self, context):
        userpath = bpy.context.scene.AFTERBURNER.assetusdpath
        if os.path.splitext(userpath)[1].lower() != ".usd":
            self.report({'WARNING'}, "Select a *.usd file (top-level USD).")
            return {'FINISHED'}

        usedir = os.path.dirname(userpath)
        if not os.path.isdir(os.path.join(usedir, "Assets")):
            self.report({'WARNING'},
                        "Export root must contain an Assets folder.")
            return {'FINISHED'}

        filename_without_extension = os.path.splitext(os.path.basename(userpath))[0]
        filepath = os.path.join(usedir,filename_without_extension + "_asset.blend")
        bpy.ops.wm.save_mainfile(filepath=filepath, check_existing=False)
        make_assets(usedir)

        #return {'FINISHED'}

        # https://developer.blender.org/T93893

        #print("5 second wait")
        #for i in range(0,50):
        #    time.sleep(0.1)

        #print("Call ensure")
        #bpy.ops.wm.previews_ensure()
        #print("After ensure")
        #for i in range(0,50):
        #    print("5 second wait")
        #    time.sleep(0.1)

        print("running pack_all")
        bpy.ops.file.pack_all()
        # filename_without_extension = os.path.splitext(os.path.basename(userpath))[0]
        # filepath = os.path.join(usedir,filename_without_extension + "_asset.blend")
        bpy.context.scene.AFTERBURNER.assetblendpath = filepath
        bpy.ops.wm.save_mainfile(filepath=filepath, check_existing=False)

        #print("Saved blender file:",filepath)


        return {'FINISHED'}


class TestOperator(bpy.types.Operator):
    """Run a test"""
    bl_idname = "afterburner.test"
    bl_label = "Testing"

    def runutil(self):
        myprop = bpy.context.scene.AFTERBURNER
        myprop.command = "renderfarm"
        myprop.sceneblendpath="D:/tmp/myproj_SC101_TK009_A001_1080P-709__426078812A_render/TrenchRun3.blend"
        myprop.blendfilepath="D:/tmp/myproj_SC101_TK009_A001_1080P-709__426078812A_render/myproj_SC101_TK009_A001_1080P-709__426078812A_rndr.blend"
        r = bpy.ops.afterburner.util()
        print(f"util returned ",r)



        # D:/tmp/processed/focal_2023-01-05/autoshot/myproj_SC101_TK009_A001_1080P-709__426078812A//camEXR/camo_01001.exr

    def execute(self, context):
        if hasattr(bpy.context.scene,"AFTERBURNER"):
            print("Autoshot plugin present")
            self.runutil()

        return {'FINISHED'}


def writestring(path,str):
    try:
        file = open(path, 'w')
    except IOError:
        print(f"Could not open {path}")

    file.write(str)
    file.close()

def gatherscenelocs():
    empty_objs = []

    for obj in bpy.data.objects:
        if obj.type == "EMPTY" and obj.name.startswith("sceneloc_"):
            empty_objs.append(obj.name)

    return empty_objs

class UtilOperator(bpy.types.Operator):
    """Multiple calls"""
    bl_idname = "afterburner.util"
    bl_label = "Util"


    # In utiloperators.py, inside the UtilOperator class

# In utiloperators.py, inside the UtilOperator class

# In utiloperators.py, inside the UtilOperator class

# In utiloperators.py, inside the UtilOperator class

    def relink_copied_results(self):
        """
        This function is executed inside a copied .blend file. It uses a dictionary
        of new relative path templates (passed via custom property) to relink media
        and update the render output directory property.
        """
        import json
        import re
        from pathlib import Path

        if not bpy.data.is_saved:
            print("Error: The Blender file being processed is not saved. Cannot relink paths.")
            return

        myprop = bpy.context.scene.AFTERBURNER
        try:
            relink_info = json.loads(myprop.jsoncommand)
        except (json.JSONDecodeError, TypeError):
            print(f"Error: Could not decode relink info from property: {myprop.jsoncommand}")
            return
        
        print(f"Received relink info for path correction: {relink_info}")

        # --- Relink Image/Media Paths ---
        for image in bpy.data.images:
            if image.source not in ('FILE', 'SEQUENCE', 'MOVIE') or not image.filepath:
                continue

            # Get the absolute path of the directory as Blender currently knows it
            current_abs_dir = Path(bpy.path.abspath(image.filepath)).parent.as_posix()
            
            # Look up this directory in our map to get the new full template
            new_relative_template = relink_info.get(current_abs_dir)

            if new_relative_template:
                # Extract the frame number from the original filename
                match = re.search(r'(\d+)\.\w+$', image.filepath)
                if not match:
                    print(f"  - WARNING: Could not extract frame number from '{image.filepath}' for image '{image.name}'")
                    continue
                
                frame_number_str = match.group(1)
                
                # Substitute the '#####' placeholder in the new template with the frame number
                final_path = new_relative_template.replace('#####', frame_number_str)
                
                print(f"  - Relinking '{image.name}''")
                print(f"  -  from '{image.filepath}'")
                print(f"  -   to '//{final_path}'")
                image.filepath = f"//{final_path}"
                image.reload()
            else:
                print(f"  - SKIPPING: No relink rule found for directory '{current_abs_dir}' of image '{image.name}'")

        # --- Update Render Path using the same logic ---
        original_render_dir_abs = Path(myprop.renderdir).as_posix()
        if original_render_dir_abs in relink_info:
            new_relative_render_template = relink_info[original_render_dir_abs]
            bpy.context.scene.render.filepath = f"//{new_relative_render_template}"
            print(f"  - Updated scene render filepath to: {bpy.context.scene.render.filepath}")
        else:
            print(f"  - WARNING: Could not find relink rule for original render directory '{original_render_dir_abs}'.")

        # --- Save the file ---
        print("Saving Blender file with updated paths.")
        bpy.ops.wm.save_mainfile(check_existing=False, compress=True)        

    def changeimagelinks(self):
         for image in bpy.data.images:
             #print(image.filepath)
             p = Path(bpy.path.abspath(image.filepath))
             folder = p.parent
            # Check for our camera image sequence
             if folder.name in ["camEXR"]:
                # Replace image sequence with movie in materials or nodes
                #print(f"image {image}")
                p = Path(bpy.path.abspath("//camo.mp4"))
                newimage = load_image(p.name, p.parent, relpath=p.parent,check_existing=True, force_reload=False)
                #print(f"newimage {newimage}")

                for mat in bpy.data.materials:
                    #print(mat)
                    if not hasattr(mat,"node_tree") or mat.node_tree == None:
                        continue

                    nodes = mat.node_tree.nodes
                    for node in nodes:
                        #print(f"node {node}")
                        if not hasattr(node,"image"):
                            continue
                        if node.image == None:
                            continue
                        if node.image.filepath == image.filepath:
                            node.image = newimage
                            node.image_user.frame_offset = 0
                            node.image_user.frame_start = bpy.context.scene.frame_start
                            print(f"{node} replace image frame_start {node.image_user.frame_start}")

                nodepile = []

                for nodeg in bpy.data.node_groups:
                    nodepile.append(nodeg.nodes)

                for scene in bpy.data.scenes:
                    if scene.node_tree != None:
                        nodepile.append(scene.node_tree.nodes)

                    # Traverse all nodes in the trees
                    for node_array in nodepile:
                        for node in node_array:
                            #print(f"node {node}")
                            if not hasattr(node,"image"):
                                continue
                            if node.image.filepath == image.filepath:
                                node.image = newimage
                                node.frame_offset = 0
                                node.frame_start = bpy.context.scene.frame_start
                                print(f"{node} replace image frame_start {node.frame_start}")


                #for users in search(image):
                #    print(users)
                #    print(users[0])

             if folder.name in ["aimattes","depth"]:
                fp = PurePath(folder.name, p.name)
                image.filepath = "//" + str(fp)
                print(f"Changed filepath to {image.filepath}")

    def changelibrary(self,scenepath):
        p = Path(scenepath)

        for library in bpy.data.libraries:
             print(library.name_full)
             if library.name_full == p.name:
                library.filepath = "//" + library.name_full # Same folder
                print(f"Now relative library {library.filepath}")


        # D:/tmp/processed/focal_2023-01-05/autoshot/myproj_SC101_TK009_A001_1080P-709__426078812A//camEXR/camo_01001.exr
    def yamlfetch(self):
        myprop = bpy.context.scene.AFTERBURNER
        yamlpath = myprop.superpath

        # Save off animation range
        frame_offset = 1000
        frame_start = 1
        groupname = CompositeKey.kGroupName
        if groupname in bpy.data.node_groups:
            if "CameraImage" in bpy.data.node_groups[groupname].nodes:
                frame_offset = bpy.data.node_groups[groupname].nodes["CameraImage"].frame_offset
                frame_start = bpy.data.node_groups[groupname].nodes["CameraImage"].frame_start

        sf = bpy.context.scene.frame_start
        ef = bpy.context.scene.frame_end
        writestring(yamlpath,f"scene_start: {sf}\nscene_end: {ef}\nframe_offset: {frame_offset}\nframe_start: {frame_start}\n")

    def checkblend(self):
        myprop = bpy.context.scene.AFTERBURNER
        #trackingpath = myprop.trackingpath
        #override = myprop.sceneloc

        yamlpath = myprop.superpath 

        #tracking = Tracking.TrackingFile(trackingpath, 0)
        #if not tracking.parse():
        #    writestring(yamlpath,f"reason: \"Parse of Tracking\"\n")
        #    return

        #scenelocname = tracking.sceneloc()
        #if override != "":
        #    scenelocname = override

        # No checking for now. Just return scenelocs from blend file
        scenelocs = gatherscenelocs()
        if len(scenelocs) == 0:
            yaml_string = "reason: \"pass\"\nscenelocs: []\n"
        else:
            yaml_string = "reason: \"pass\"\nscenelocs:\n{}\n".format('\n'.join(['  - {}'.format(name) for name in scenelocs]))
        writestring(yamlpath,yaml_string)
        return

        if scenelocname != "origin":
            ob = bpy.data.objects.get(scenelocname)
            if ob != None:
                writestring(yamlpath,f"reason: \"pass\"\n")
            else:
                print(f"--------> sceneloc not found {scenelocname}")
                empty_objs = gatherscenelocs()
                if len(empty_objs) == 0:
                    yaml_string = "reason: \"Invalid Sceneloc\"\nscenelocs: []\n"
                else:
                    yaml_string = "reason: \"Invalid Sceneloc\"\nscenelocs:\n{}\n".format('\n'.join(['  - {}'.format(name) for name in empty_objs]))
                writestring(yamlpath,yaml_string)
        else:
            writestring(yamlpath,f"reason: \"pass\"\n")



    def renderfarm(self):
        myprop = bpy.context.scene.AFTERBURNER
        #sceneblendpath = myprop.sceneblendpath
        blendfilepath = myprop.blendfilepath

        # We have rndr file open
        try:
            bpy.ops.file.pack_libraries()
        except:
            print("pack_libraries did not complete cleanly")

        try:
            bpy.ops.file.pack_all()
        except:
            print("pack_all did not complete cleanly")

        # Save to a file in our export folder
        print("Try to save file:",blendfilepath)

        try:
            bpy.ops.wm.save_as_mainfile(filepath=blendfilepath, copy= True, check_existing=False)
        except:
            print("save_as_mainfile did not complete cleanly")

        # Reopen in our export folder
        bpy.ops.wm.open_mainfile(filepath=blendfilepath, load_ui=True, display_file_selector=False)
        #self.changelibrary(sceneblendpath)
        #bpy.ops.file.find_missing_files()
        
        bpy.ops.file.report_missing_files()
 
        self.changeimagelinks()

        bpy.ops.file.report_missing_files()

        bpy.context.scene.render.filepath = "//rndrEXR/rndr_#####"
        defaultcyclessettings()
        # Save on top compressed
        bpy.ops.wm.save_mainfile(filepath=blendfilepath, check_existing=False, compress=True)

    def execute(self, context):
        if hasattr(bpy.context.scene,"AFTERBURNER"):
            print("Autoshot plugin present")
            myprop = bpy.context.scene.AFTERBURNER
            if myprop.command == "renderfarm":
                self.renderfarm()
            elif myprop.command == "yamlfetch":
                self.yamlfetch()
            elif myprop.command == "checkblend":
                self.checkblend()
            elif myprop.command == "copyresults_relink":
                self.relink_copied_results()
            else:
                print(f"Unknown command {myprop.command}")

        return {'FINISHED'}

def defaultcyclessettings():
    bpy.context.scene.cycles.preview_samples = 64
    bpy.context.scene.cycles.samples = 128
    bpy.context.scene.cycles.use_denoising = True
    
    
